#!/bin/bash
I2CBus=4
I2CAdd=0x21
#Set IO
sudo i2cset -y $I2CBus $I2CAdd 0x00 0x00
sudo i2cset -y $I2CBus $I2CAdd 0x01 0x0F

#portA LED off
sudo i2cset -y $I2CBus $I2CAdd 0x12 0xFF
#portB LED off
sudo i2cset -y $I2CBus $I2CAdd 0x13 0xF0

while [ 1 ]; do
	SWstatePrev=$SWstate
	SWstate=`sudo i2cget -y $I2CBus $I2CAdd 0x13`
	SWstate=$(( SWstate & 0x0F))
	if [ "$SWstate" != "$SWstatePrev" ] ;then
		if [ "$SWstate" != "0" ] ;then
			if [ "$SWstate" = "1" ] ;then
				echo "SW1 Pushed"
				LEDState=0x0DB3
			elif [ "$SWstate" = "2" ] ;then
				echo "SW2 Pushed"
				LEDState=0x0D9E
			elif [ "$SWstate" = "4" ] ;then
				echo "SW3 Pushed"
				LEDState=0x0CF6
			elif [ "$SWstate" = "8" ] ;then
				echo "SW4 Pushed"
				LEDState=0x07B6
			fi
			sudo i2cset -y $I2CBus $I2CAdd 0x12 $(( (LEDState>>4) & 0xFF ))
			sudo i2cset -y $I2CBus $I2CAdd 0x13 $(( (LEDState & 0x0F)<<4 ))
		fi
	fi
done

