#!/bin/bash

#please install following tools
#sudo apt-get install i2c-tools
#sudo apt-get install xclip
#sudo apt-get install xdotool

#parameters
I2Cbus=4 # Search by "check_newI2C.sh"
I2CAddress=0x27 #LCD I2C address
LCD_BACKLIGHT=0x08 #LCD ON
ENABLE=0x04
DISABLE=0xFB

###Functions###
LCDSEND() {
#$1 1byte data
#$2 0:Command 1:Character
    I2CCMD $(($1 & 0xF0 | $LCD_BACKLIGHT | $2))             #first 4bit
    I2CCMD $((($1 << 4) & 0xF0 | $LCD_BACKLIGHT | $2))      #last 4bit
}

I2CCMD() {
#No need sleep because bash runs slow.
    sudo i2cset -y $I2Cbus $I2CAddress $1 
    sudo i2cset -y $I2Cbus $I2CAddress $(($1 | $ENABLE))
    sudo i2cset -y $I2Cbus $I2CAddress $(($1 & $DISABLE)) 
}

LCDPRINT() {
#LCDPRINT String X Y
    LCDCURSOR $2 $3
    i=0
    echo -n $1 | while read -N1 c; do
        d=$(echo -n "$c" | iconv -t UCS-2BE | xxd -p);
        LCDSEND "0x$d" 1
        i=$((i+1))
        if [ $i -eq $((20 - $2)) ] ;then
            break
        fi
    done

    i=${#1}
    if [ $i -lt $((20 - $2)) ] ;then
        while [ $i -lt $((20 - $2)) ] ;do
            LCDSEND "0x20" 1
            i=$((i+1))
        done
    fi
}

LCDCURSOR() {
#LCDCURSOR X Y
    if [ $2 -eq 0 ];then
        Cursor=0x80
    elif [ $2 -eq 1 ];then
        Cursor=0xC0
    elif [ $2 -eq 2 ];then
        Cursor=0x94
    elif [ $2 -eq 3 ];then
        Cursor=0xD4
    fi
    Cursor=$((Cursor + $1 ))
    LCDSEND $Cursor 0
}

LCDCLEAR() {
    LCDSEND 0x01 0
}

###Command###
bash ./vmstat2file.sh & #Monitor CPU in background

#Initial
LCDSEND 0x33 0
LCDSEND 0x32 0
LCDSEND 0x06 0
LCDSEND 0x0C 0
LCDSEND 0x28 0
LCDSEND 0x01 0

#Print demo
LCDPRINT "Hello World" 0 0
LCDPRINT "Ctrl from HDMI port" 0 1
LCDPRINT "piONE.jp channel" 0 3
sleep 2

#print Clip board, mouse position and CPU usage.
LCDCLEAR
LCDPRINT "Clip board:" 0 0
LCDPRINT "Mouse:" 0 2
LCDPRINT "CPU Usage:" 0 3
while [ 1 ]; do
    CBStrPrev=CBStr
    CBStr=`xclip -o 2> /dev/null`
    if [ "$CBStr" != "$CBStrPrev" ] ;then
        LCDPRINT "$CBStr" 1 1
    fi
    eval $(xdotool getmouselocation --shell)
    MousePosition=`printf "(%d,%d)" $X $Y`
    LCDPRINT "$MousePosition" 6 2

    CPU=`cat .vmstat_last | awk -F' ' '{print $15}'`
    CPU=$((100-CPU))
    CPU=`printf "%d%%" $CPU`
    LCDPRINT "$CPU" 10 3
done
