#!/bin/bash

#please install following tools
#sudo apt-get install i2c-tools

filename=`date +%Y-%m-%d-%H-%M`
filename="check_newI2C_${filename}"


echo -n "Disconnect Target Device and press enter."
read ans
echo "Searching for I2C devices."

busn=0
while read line ;do
    busi=`echo ${line//-/ } | awk -F' ' '{print $2}'`
    if [ $busi -gt $busn ] ;then
        busn=$busi
    fi
done << END
 `i2cdetect -l`
END

for i in `seq 0 $busn` ;do
    sudo i2cdetect -y $i | while read line ;do
        echo "$i $line" >> "${filename}-1"
    done    
done

echo -n "Connect Target Device and press enter."
read ans
echo "Searching for I2C devices."

for i in `seq 0 $busn` ;do
    sudo i2cdetect -y $i | while read line ;do
        echo "$i $line" >>  "${filename}-2"
    done
done

diffresult=`diff  "${filename}-1" "${filename}-2" | tail -n 1`
diffresult=${diffresult//-- /}
bus=`echo "$diffresult" | awk -F' ' '{print $ 2}'`
i2cadd=`echo "$diffresult" | awk -F' ' '{print $ 4}'`
echo "Finished"
echo "------"


echo "I2C Bus: $bus"
echo "I2C Address: 0x$i2cadd"
rm  "${filename}"*
